#
# Set manipulation
# Evan Rempel erempel@UVic.CA
# Apr 4, 2000

# --------------------------------------------------------- 
# The set package provides a way to manipulating lists as if
# they were sets.
 
package provide Set 1.2

namespace eval ::Set {
  namespace export null create add intersection union difference subtract
  namespace export isnull list
}

proc ::Set::null { } {
  return {}
}

# --------------------------------------------------------- create
# return a set created from elements in list.
proc ::Set::create { list } {

  foreach item $list {
    set items($item) 1
  }
  return [array names items]
}

# --------------------------------------------------------- list
# return a set created from elements in list.
proc ::Set::list { set } {

  return $set
}

# --------------------------------------------------------- add
# add one itemto the set.
# This is intended for rapid building of sets. It is much
# faster than set a [set::union $a $item]
proc ::Set::add { S1 item } {
  upvar $S1 set1

  if {[lsearch -exact $set1 $item] < 0} then {
    lappend set1 $item
  }
  return 0
}

# --------------------------------------------------------- intersection
# return a set comprised of elements that are in both
# sets S1 and S2
proc ::Set::intersection { S1 S2 } {

  array set set1 {}
  foreach n $S1 {
    set set1($n) ""
  }
  array set tempSet {}
  foreach n $S2 {
    if {[info exists set1($n)]} then {
      set tempSet($n) ""
    }
  }
  return [array names tempSet]
}

# --------------------------------------------------------- union
# create a set comprised of elements found in either
# set S1 or S2
proc ::Set::union { S1 S2 } {

  array set tempSet {}
  foreach item $S1 {
    set tempSet($item) ""
  }
  foreach item $S2 {
    set tempSet($item) ""
  }
  return [array names tempSet]
}

# --------------------------------------------------------- difference
# create s set comprised of elements that are not in
# both sets S1 and S2. Same as saying elements found only
# in one of the sets S1 and S2
proc ::Set::difference { S1 S2 } {

  array set tempSet {}
  foreach n $S1 {
    set tempSet($n) ""
  }
  foreach n $S2 {
    if {[info exists tempSet($n)]} then {
      unset tempSet($n)
    } else {
      set tempSet($n) ""
    }
  }
  return [array names tempSet]
}

# --------------------------------------------------------- subtract
# create a list comprised of all elements in S1 that are
# not in S2. Same as saying take all elements in set S2 out of
# set S1
proc ::Set::subtract { S1 S2 } {

  array set tempSet {}
  foreach n $S1 {
    set tempSet($n) ""
  }
  foreach n $S2 {
    if {[info exists tempSet($n)]} then {
      unset tempSet($n)
    }
  }
  return [array names tempSet]
}

# --------------------------------------------------------- isnull
# return true (1) if set S1 is empty, otherwise return false (0)
proc ::Set::isnull { S1 } {
  if {[llength $S1] > 0} then {
    return 0
  } else {
    return 1
  }
}
